<?php
/*--------------------------------------------------------------------------------------------------
    eustandardtransfer_payment_module_repair.php 2022-11-22
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2022 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

/** @var DatabaseModel $this */
/** @var int $t_success */

// Checks if the "EU Standard Bank Transfer" payment module is installed and adds the missing module configuration:
// "configuration/MODULE_PAYMENT_EUTRANSFER_SORT_CODE"
$sql = "SELECT * FROM `gx_configurations` WHERE `key` = 'configuration/MODULE_PAYMENT_INSTALLED';";
$result = $this->query($sql, true);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    if (strpos($row['value'], 'eustandardtransfer.php') !== false) {
        $sql = "SELECT * FROM `gx_configurations` WHERE `key` = 'configuration/MODULE_PAYMENT_EUTRANSFER_SORT_CODE';";
        $result = $this->query($sql, true);
    
        if ($result->num_rows < 1) {
            $insertSql = "INSERT INTO `gx_configurations` (`key`, `value`, `default` ,`sort_order`, `last_modified`) VALUES ('configuration/MODULE_PAYMENT_EUTRANSFER_SORT_CODE', '---', '---', '0', now())";
            $t_success &= $this->query($insertSql, true);
        }
    }
}